package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 * 附件目录表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "附件目录表VO")
public class ComFile extends BaseEntity {

    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 1 )
    @Length(max=36, message = "附件Id不能大于36")
    private String downloadId;
    /** 对象Id(项目Id/任务书Id) */
    @ApiModelProperty(value = "对象Id(项目Id/任务书Id)", position = 2 )
    @Length(max=36, message = "对象Id(项目Id/任务书Id)不能大于36")
    private String objectId;
    /** 附件说明 */
    @ApiModelProperty(value = "附件说明", position = 3 )
    @Length(max=300, message = "附件说明不能大于300")
    private String fileExplain;
    /** 文件类型 */
    @ApiModelProperty(value = "文件类型", position = 3)
    private Integer fileType;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 10 )
    private Integer showIndex;
    /** 必须上传的附件 */
    @ApiModelProperty(value = "必须上传的附件", position = 8)
    private Boolean isRequired;
    /** 是否为标题 */
    @ApiModelProperty(value = "是否为标题", position = 8)
    private Boolean isTitle;

}