package com.yiboshi.science.utils;

import org.springframework.stereotype.Component;

/**

/**
 * class: 创建单位treeCode$
 * create by: $
 * description:
 * create time: $
 *
 * @param: $
 */
@Component
public class CreateCodeUtil {

    private final char[] letterArr = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public String getTreeCode(String fatherCode, String maxCode) {
        String returnCode="";
        if (!maxCode.isEmpty() && !fatherCode.isEmpty()) {
            String lastCode = maxCode.substring(maxCode.length() - 2);
            Integer temp = 0;
            String newCode = "";
            if (ParseInt(lastCode)) {
                temp = Integer.parseInt(lastCode);
                if (temp == 99)
                    newCode = "a0";
                else
                    newCode = getNumberCode(temp);
            } else
                newCode = getCharCode(lastCode);
            if (!newCode.isEmpty()) {
                returnCode= fatherCode + newCode;
            } else
                returnCode= fatherCode + "01";
        } else
            returnCode= fatherCode + "01";
        return returnCode.toUpperCase();
    }

    private String getNumberCode(Integer num) {
        if (num < 9)
            return "0" + (num + 1);
        else
            return num + 1 + "";
    }

    private String getCharCode(String lastCode) {
        char first=lastCode.toLowerCase().charAt(0);
        char second=lastCode.toLowerCase().charAt(1);
        int secondIndex=getIndex(second);
        if(secondIndex<10){
            second=getCode(secondIndex+1);
        }else {
            second=getCode(0);
            first=getCode(getIndex(first)+1);
        }
        return first+""+second;
    }

    /**
     * 字符换取索引
     * @param c
     * @return
     */
    private int getIndex(char c){
        for (int i = 0; i <letterArr.length ; i++) {
            if(c==letterArr[i]){
                return i;
            }
        }
        return 0;
    }
    /**
     * 索引换取字符
     * @param index
     * @return
     */
    private char getCode(int index){
        return letterArr[index];
    }

    public boolean ParseInt(String str) {
        if (str == null) {
            return false;
        }
        //使用正则表达式判断该字符串是否为数字，第一个\是转义符，\d+表示匹配1个或 //多个连续数字，"+"和"*"类似，"*"表示0个或多
        return str.matches("\\d+");
    }
}
