package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComTalentGroupAssignDAO;
import com.yiboshi.science.entity.ComTalentGroupAssign;
import com.yiboshi.science.entity.SystemParameter;
import com.yiboshi.science.param.dto.*;
import com.yiboshi.science.param.query.ComTalentGroupAssignQueryVO;
import com.yiboshi.science.service.ComExpertSpecService;
import com.yiboshi.science.service.ComTalentGroupAssignService;
import com.yiboshi.science.service.SystemParameterService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 人才分组分配表 Service 实现类
 *
 * @author xujun
 * @version 2025-07-23
 */

@Service
@AllArgsConstructor
public class ComTalentGroupAssignServiceImpl extends BaseServiceImpl<ComTalentGroupAssignDAO, ComTalentGroupAssignQueryVO, ComTalentGroupAssignDTO, ComTalentGroupAssign> implements ComTalentGroupAssignService {

    @Autowired
    private ComTalentGroupAssignDAO comTalentGroupAssignDAO;

    @Autowired
    private ComExpertSpecService comExpertSpecService;

    @Autowired
    private SystemParameterService systemParameterService;

    @Override
    protected void setCriteriaForQuery(ComTalentGroupAssignQueryVO vo, QueryWrapper<ComTalentGroupAssignQueryVO> criteria) {

    }

    public List<ComTalentGroupAssignDTO> getAssignExpertList(String groupId) {
        List<ComTalentGroupAssignDTO> groupAssignList = comTalentGroupAssignDAO.getAssignExpertList(groupId);
        groupAssignList.forEach(e -> {
            //e.setExpertType(comExpertSpecService.getExpertTypeByExpertId(e.getExpertId()));
            e.setSpecList(comExpertSpecService.getListByExpertId(e.getExpertId()));
        });
        return groupAssignList;
    }

    public ComTalentGroupAssignDTO getAssignGroupExpertById(String Id) {
        ComTalentGroupAssignDTO dto = comTalentGroupAssignDAO.getAssignGroupExpertById(Id);
        List<ComExpertSpecDTO> list = comExpertSpecService.getListByExpertId(dto.getExpertId());
        if (null != list && list.size() > 0)
            dto.setSpecList(list);

        List<ComTalentAssignDTO> assignList = comTalentGroupAssignDAO.getTalentAssignByGroupIdExpertId(dto.getGroupId(), dto.getExpertId());
        if (null != assignList && assignList.size() > 0) {
            assignList.forEach(e -> {
                if (Objects.nonNull(e.getTalentCategory())) {
                    SystemParameter parameter = systemParameterService.getParameterById(e.getTalentCategory());
                    e.setTalentCategoryName(parameter.getName());
                }
            });
            dto.setTalentAssignList(assignList);
        }

        return dto;
    }
}
