package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectResearchDAO;
import com.yiboshi.science.entity.ComProjectResearch;
import com.yiboshi.science.param.dto.ComProjectResearchDTO;
import com.yiboshi.science.param.query.ComProjectResearchQueryVO;
import com.yiboshi.science.service.ComProjectResearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 项目申请书在研项目情况表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComProjectResearchServiceImpl extends BaseServiceImpl<ComProjectResearchDAO,ComProjectResearchQueryVO, ComProjectResearchDTO,ComProjectResearch> implements ComProjectResearchService {
    @Autowired
    private ComProjectResearchDAO comProjectResearchDAO;

    @Override
    protected void setCriteriaForQuery(ComProjectResearchQueryVO vo, QueryWrapper<ComProjectResearchQueryVO> criteria) {
        if(Objects.nonNull(vo.getObjectId())){
            criteria.eq("object_id", vo.getObjectId());
        }
        if(Objects.nonNull(vo.getProjNo())){
            criteria.eq("proj_no", vo.getProjNo());
        }
        if(Objects.nonNull(vo.getProjName())){
            criteria.eq("proj_name", vo.getProjName());
        }
        if(Objects.nonNull(vo.getApproveUnit())){
            criteria.eq("approve_unit", vo.getApproveUnit());
        }
        if(Objects.nonNull(vo.getLeader())){
            criteria.eq("leader", vo.getLeader());
        }
    }
    @Override
    public List<ComProjectResearchDTO> getListByObjectId(String objectId) {
        return comProjectResearchDAO.getListByObjectId(objectId);
    }

    public void insertList(List<ComProjectResearchDTO> list, String objectId) {
        ComProjectResearch file = new ComProjectResearch();
        file.setObjectId(objectId);
        this.delete(file);
        if (null != list) {
            for (int i = 0; i < list.size(); i++) {
                if (!isObjectNull(list.get(i))) {
                    list.get(i).setObjectId(objectId);
                    list.get(i).setShowIndex(i + 1);
                    ComProjectResearch comProjectResearch = convert2Entity(list.get(i));
                    this.insert(comProjectResearch);
                }
            }
        }
    }

    public void deleteByObjectId(String objectId) {
        ComProjectResearch E = new ComProjectResearch();
        E.setObjectId(objectId);
        this.delete(E);
    }



}
