package com.yiboshi.science.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectManagementRuleDAO;
import com.yiboshi.science.entity.ComProjectManagementRule;
import com.yiboshi.science.param.dto.ComProjectManagementRuleDTO;
import com.yiboshi.science.param.query.ComProjectManagementRuleQueryVO;
import com.yiboshi.science.service.ComProjectManagementRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 单位科研项目及资金管理制度表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComProjectManagementRuleServiceImpl extends BaseServiceImpl<ComProjectManagementRuleDAO, ComProjectManagementRuleQueryVO, ComProjectManagementRuleDTO, ComProjectManagementRule> implements ComProjectManagementRuleService {
    @Autowired
    private ComProjectManagementRuleDAO comProjectManagementRuleDAO;

    protected void setCriteriaForQuery(ComProjectManagementRuleQueryVO vo, QueryWrapper<ComProjectManagementRuleQueryVO> criteria) {

    }

    @Override
    public List<ComProjectManagementRuleDTO> getListByObjectId(String objectId) {
        return comProjectManagementRuleDAO.getListByObjectId(objectId);
    }

    public void insertList(List<ComProjectManagementRuleDTO> list, String objectId) {
        ComProjectManagementRule file = new ComProjectManagementRule();
        file.setObjectId(objectId);
        this.delete(file);
        if (null != list) {
            for (int i = 0; i < list.size(); i++) {
                if (!isObjectNull(list.get(i))) {
                    list.get(i).setObjectId(objectId);
                    list.get(i).setShowIndex(i + 1);
                    list.get(i).setFileId(list.get(i).getDownloadId());
                    ComProjectManagementRule comProjectManagementRule = convert2Entity(list.get(i));
                    this.insert(comProjectManagementRule);
                }
            }
        }
    }

    public void deleteByObjectId(String objectId) {
        ComProjectManagementRule E = new ComProjectManagementRule();
        E.setObjectId(objectId);
        this.delete(E);
    }
}
