package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComPersonScientificGainDAO;
import com.yiboshi.science.entity.ComPersonScientificGain;
import com.yiboshi.science.param.dto.ComPersonScientificGainDTO;
import com.yiboshi.science.param.query.ComPersonScientificGainQueryVO;
import com.yiboshi.science.service.ComPersonScientificGainService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 申报人科研学术成绩表 Service 实现类
 * @author xujun
 * @version 2025-03-12
 */

@Service
@AllArgsConstructor
public class ComPersonScientificGainServiceImpl extends BaseServiceImpl<ComPersonScientificGainDAO, ComPersonScientificGainQueryVO, ComPersonScientificGainDTO, ComPersonScientificGain> implements ComPersonScientificGainService {

    @Autowired
    private ComPersonScientificGainDAO comPersonScientificGainDAO;

    @Override
    protected void setCriteriaForQuery(ComPersonScientificGainQueryVO vo, QueryWrapper<ComPersonScientificGainQueryVO> criteria) {

    }

    public void insertList(List<ComPersonScientificGainDTO> list, String TalentId, String TypeId) {
        ComPersonScientificGain ScientificGain = new ComPersonScientificGain();
        ScientificGain.setTalentId(TalentId);
        ScientificGain.setGainType(TypeId);
        this.delete(ScientificGain);

        if (null != list) {
            List<ComPersonScientificGain> iList = new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                ComPersonScientificGain item = convert2Entity(list.get(i));
                item.setTalentId(TalentId);
                item.setGainType(TypeId);
                iList.add(item);
            }
            this.insertBatch(iList);
        }
    }

    public List<ComPersonScientificGainDTO> getListByTalentId(String TalentId) {
        return comPersonScientificGainDAO.getListByTalentId(TalentId);
    }

    public void deleteByObjectId(String objectId) {
        ComPersonScientificGain e = new ComPersonScientificGain();
        e.setTalentId(objectId);
        this.delete(e);
    }
}
