package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.arch.exception.BusinessException;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComExpertBatchDAO;
import com.yiboshi.science.entity.ComExpertBatch;
import com.yiboshi.science.param.dto.ComExpertBatchDTO;
import com.yiboshi.science.param.query.ComExpertBatchQueryVO;
import com.yiboshi.science.service.ComExpertBatchService;
import com.yiboshi.science.service.ComExpertGroupService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Objects;


@Service
@AllArgsConstructor
public class ComExpertBatchServiceImpl extends BaseServiceImpl<ComExpertBatchDAO, ComExpertBatchQueryVO, ComExpertBatchDTO, ComExpertBatch> implements ComExpertBatchService {

    @Autowired
    private ComExpertBatchDAO comExpertBatchDAO;

    @Autowired
    private ComExpertGroupService comExpertGroupService;


    @Override
    protected void setCriteriaForQuery(ComExpertBatchQueryVO vo, QueryWrapper<ComExpertBatchQueryVO> criteria) {
        if (Objects.nonNull(vo.getName())) {
            criteria.like("name", vo.getName());
        }
        if (Objects.nonNull(vo.getYear())) {
            criteria.eq("year", vo.getYear());
        }
        if (Objects.nonNull(vo.getBatch())) {
            criteria.eq("batch", vo.getBatch());
        }
        criteria.orderByDesc("year");
        criteria.orderByAsc("batch");
    }

    @Override
    @Transactional
    public String save(ComExpertBatchDTO dto) {
        String batchId = "";
        ComExpertBatch ComExpertBatch = new ComExpertBatch();
        if (Objects.isNull(dto.getId())) {
            ComExpertBatch.setYear(dto.getYear());
            ComExpertBatch.setBatch(dto.getBatch());
            ComExpertBatch = this.getEntity(ComExpertBatch);
            if (null != ComExpertBatch) {
                throw new BusinessException("批次已存在，请重试！");
            }
            ComExpertBatch = convert2Entity(dto);
            batchId = this.insert(ComExpertBatch);
        } else {
            ComExpertBatch = this.getById(dto.getId());
            if (null == ComExpertBatch)
                throw new BusinessException("批次不存在，请刷新页面后重试！");
            if (!ComExpertBatch.getYear().equals(dto.getYear()) || !ComExpertBatch.getYear().equals(dto.getYear())) {
                ComExpertBatch = new ComExpertBatch();
                ComExpertBatch.setYear(dto.getYear());
                ComExpertBatch.setBatch(dto.getBatch());
                ComExpertBatch = this.getEntity(ComExpertBatch);
                if (null != ComExpertBatch)
                    throw new BusinessException("批次已存在，请重试！");
            }
            ComExpertBatch = convert2Entity(dto);
            batchId = this.update(ComExpertBatch);
        }
        if (Objects.nonNull(dto.getExpertGroup()) && dto.getExpertGroup().size() > 0) {
            comExpertGroupService.insertOrUpdateGroupList(dto.getExpertGroup(), batchId);
        }
        return batchId;
    }

    @Override
    public ComExpertBatchDTO getBatchById(String id) {
        ComExpertBatchDTO comExpertBatchDTO = this.dtoById(id);
        if (null == comExpertBatchDTO)
            throw new BusinessException("批次不存在，请重试！");
        comExpertBatchDTO.setExpertGroup(comExpertGroupService.getExpertGroupListByBatchId(id));
        return comExpertBatchDTO;
    }

    @Override
    public String deleteByBatchId(String id){
        return id;
    }
}
