package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComEvaluationValueDAO;
import com.yiboshi.science.entity.ComEvaluationValue;
import com.yiboshi.science.param.dto.ComEvaluationItemDTO;
import com.yiboshi.science.param.dto.ComEvaluationValueDTO;
import com.yiboshi.science.param.dto.ComProjectAssignDTO;
import com.yiboshi.science.param.query.ComEvaluationValueQueryVO;
import com.yiboshi.science.service.ComEvaluationItemService;
import com.yiboshi.science.service.ComEvaluationValueService;
import com.yiboshi.science.utils.StringUtil;
import lombok.AllArgsConstructor;
import org.apache.poi.hpsf.Decimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
public class ComEvaluationValueServiceImpl extends BaseServiceImpl<ComEvaluationValueDAO, ComEvaluationValueQueryVO, ComEvaluationValueDTO, ComEvaluationValue> implements ComEvaluationValueService {

    @Autowired
    private ComEvaluationValueDAO comEvaluationValueDAO;

    @Autowired
    private ComEvaluationItemService comEvaluationItemService;

    @Override
    protected void setCriteriaForQuery(ComEvaluationValueQueryVO vo, QueryWrapper<ComEvaluationValueQueryVO> criteria) {

    }

    public List<ComEvaluationValueDTO> getListByAssignId(String assignId) {
        List<ComEvaluationValueDTO> list = comEvaluationValueDAO.getListByAssignId(assignId);
        if (null == list || list.size() == 0) {
            List<ComEvaluationItemDTO> dtoList = comEvaluationItemService.getListByEvaluationId();
            dtoList.forEach((e) -> {
                ComEvaluationValueDTO dto = new ComEvaluationValueDTO();
                StringUtil.copyObj2Obj(e, dto);
                dto.setItemId(e.getId());
                dto.setAssignId(assignId);
                list.add(dto);
            });
        }
        final String[] parentId1 = {""};
        final String[] parentId2 = {""};
        final String[] parentId3 = {""};
        final int[] groupIndex = {0};
        final int[] groupItem = {0};
        final List<Integer>[] itemList = new List[]{new ArrayList<>()};
        list.forEach((e) -> {
            if (!parentId1[0].equals(e.getParentId1())) {
                Integer row1 = list.stream().filter(f -> f.getParentId1().equals(e.getParentId1())).collect(Collectors.toList()).size();
                e.setRow1(row1);
                parentId1[0] = e.getParentId1();
            } else {
                e.setRow1(0);
            }
            if (!parentId2[0].equals(e.getParentId2())) {
                Integer row2 = list.stream().filter(f -> f.getParentId2().equals(e.getParentId2())).collect(Collectors.toList()).size();
                e.setRow2(row2);
                parentId2[0] = e.getParentId2();
            } else {
                e.setRow2(0);
            }
            if (!parentId3[0].equals(e.getParentId3())) {
                Integer row3 = list.stream().filter(f -> f.getParentId3().equals(e.getParentId3())).collect(Collectors.toList()).size();
                e.setRow3(row3);
                itemList[0] = new ArrayList<>();
                groupIndex[0]++;
                parentId3[0] = e.getParentId3();
            } else {
                e.setRow3(0);
            }
            itemList[0].add(groupItem[0]);
            e.setGroupItem(itemList[0]);
            e.setGroupName("group" + groupIndex[0]);
            groupItem[0]++;
        });
        return list;
    }

    /**
     * 插入列表
     *
     * @param list
     * @param assignId
     */
    @Override
    public BigDecimal insertListByAssignId(List<ComEvaluationValueDTO> list, String assignId) {
        BigDecimal totalScore = new BigDecimal(0);
        this.deleteListByAssignId(assignId);
        if (null != list) {
            for (ComEvaluationValueDTO d : list) {
                if (!isObjectNull(d)) {
                    if (Objects.nonNull(d.getScore())) {
                        totalScore = totalScore.add(d.getScore());
                    }
                    d.setAssignId(assignId);
                    if (d.getValueType().equals(3)) {
                        BigDecimal score = new BigDecimal(0);
                        if (Objects.nonNull(d.getCount()))
                            score = d.getCount().multiply(new BigDecimal(1));
                        d.setScore(score);
                    }
                    ComEvaluationValue e = convert2Entity(d);
                    this.insert(e);
                }
            }
        }
        return totalScore;
    }

    /**
     * 删除对象列表
     *
     * @param assignId
     */
    @Override
    public void deleteListByAssignId(String assignId) {
        ComEvaluationValue e = new ComEvaluationValue();
        e.setAssignId(assignId);
        this.delete(e);
    }
}
