package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.ComConclusionResearchersDAO;
import com.yiboshi.science.entity.ComConclusionResearchers;
import com.yiboshi.science.param.dto.ComConclusionResearchersDTO;
import com.yiboshi.science.param.query.ComConclusionResearchersQueryVO;
import com.yiboshi.science.service.ComConclusionResearchersService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 结题主要研究人员表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComConclusionResearchersServiceImpl extends BaseServiceImpl<ComConclusionResearchersDAO, ComConclusionResearchersQueryVO, ComConclusionResearchersDTO, ComConclusionResearchers> implements ComConclusionResearchersService {

    @Autowired
    private ComConclusionResearchersDAO comConclusionResearchersDAO;

    @Override
    protected void setCriteriaForQuery(ComConclusionResearchersQueryVO vo, QueryWrapper<ComConclusionResearchersQueryVO> criteria) {

    }

    @Override
    public Pagination<ComConclusionResearchersDTO> getListByPage(ComConclusionResearchersQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        Page<ComConclusionResearchersQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<ComConclusionResearchersDTO> dtoList = comConclusionResearchersDAO.getListByPage(page, criteria).getRecords();
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }

    @Override
    public List<ComConclusionResearchersDTO> getListByObjectId(String objectId) {
        List<ComConclusionResearchersDTO> list = comConclusionResearchersDAO.getListByObjectId(objectId);
        return list;
    }

    @Override
    public void insertList(List<ComConclusionResearchersDTO> list, String objectId) {
        ComConclusionResearchers e = new ComConclusionResearchers();
        e.setConclusionId(objectId);
        this.delete(e);
        if (null != list) {
            for (int i = 0; i < list.size(); i++) {
                if (!isObjectNull(list.get(i))) {
                    list.get(i).setConclusionId(objectId);
                    list.get(i).setShowIndex(i+1);
                    ComConclusionResearchers model = convert2Entity(list.get(i));
                    this.insert(model);
                }
            }
        }
    }
}
