package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.ComConclusionFundsDAO;
import com.yiboshi.science.entity.ComConclusionFunds;
import com.yiboshi.science.param.dto.ComConclusionFundsDTO;
import com.yiboshi.science.param.query.ComConclusionFundsQueryVO;
import com.yiboshi.science.service.ComConclusionFundsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 结题经费记录表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComConclusionFundsServiceImpl extends BaseServiceImpl<ComConclusionFundsDAO, ComConclusionFundsQueryVO, ComConclusionFundsDTO, ComConclusionFunds> implements ComConclusionFundsService {

    @Autowired
    private ComConclusionFundsDAO comConclusionFundsDAO;

    @Override
    protected void setCriteriaForQuery(ComConclusionFundsQueryVO vo, QueryWrapper<ComConclusionFundsQueryVO> criteria) {

    }

    @Override
    public Pagination<ComConclusionFundsDTO> getListByPage(ComConclusionFundsQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        Page<ComConclusionFundsQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<ComConclusionFundsDTO> dtoList = comConclusionFundsDAO.getListByPage(page, criteria).getRecords();
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }

    @Override
    public List<ComConclusionFundsDTO> getListByObjectId(String objectId, Integer type) {
        List<ComConclusionFundsDTO> list = comConclusionFundsDAO.getListByObjectId(objectId, type);
        return list;
    }

    @Override
    public void insertList(List<ComConclusionFundsDTO> list, String objectId, Integer type) {
        ComConclusionFunds e = new ComConclusionFunds();
        e.setConclusionId(objectId);
        e.setType(type);
        this.delete(e);
        if (null != list) {
            for (int i = 0; i < list.size(); i++) {
//                if (Objects.nonNull(list.get(i).getYear()) || Objects.nonNull(list.get(i).getAmount()) || Objects.nonNull(list.get(i).getName()) || Objects.nonNull(list.get(i).getUsed())) {
//                    list.get(i).setConclusionId(objectId);
//                    list.get(i).setShowIndex(i + 1);
//                    list.get(i).setType(type);
//                    ComConclusionFunds model = convert2Entity(list.get(i));
//                    this.insert(model);
//                }
                list.get(i).setConclusionId(objectId);
                list.get(i).setShowIndex(i + 1);
                list.get(i).setType(type);
                ComConclusionFunds model = convert2Entity(list.get(i));
                this.insert(model);
            }
        }
    }
}
