package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.SystemMenu;
import com.yiboshi.science.param.dto.MenuTreeDTO;
import com.yiboshi.science.param.dto.SystemMenuDTO;
import com.yiboshi.science.param.dto.UserMenuDTO;
import com.yiboshi.science.param.query.SystemMenuQueryVO;

import java.util.List;

/**
 * 菜单表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface SystemMenuService extends BaseService<SystemMenuQueryVO, SystemMenuDTO,SystemMenu>{
    /** 根据角色获取菜单
     *
     * @param roleId
     * @return
     */
    List<UserMenuDTO> findByRoleId(String roleId,Integer systemType);
    /** 获取菜单树
     *
     * @param
     * @return
     */
    List<MenuTreeDTO> getAllMenuTree();
    /** 获取菜单树
     *
     * @param parentId
     * @return
     */
    List<SystemMenu> getSystemMenuByParentId(String parentId);
    /** 获取菜单根据Id
     *
     * @param
     * @return
     */
    SystemMenu getSystemMenuById(String id);
    /** 添加
     *
     * @param
     * @return
     */
    String insertSystemMenu(SystemMenu systemMenu);
    /** 更新
     *
     * @param
     * @return
     */
    String updateSystemMenu(SystemMenu systemMenu);
}
