package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComTalentGroup;
import com.yiboshi.science.param.dto.ComProjectGroupDTO;
import com.yiboshi.science.param.dto.ComProjectKnowledgeStatisticDTO;
import com.yiboshi.science.param.dto.ComTalentGroupDTO;
import com.yiboshi.science.param.dto.ComTalentKnowledgeStatisticDTO;
import com.yiboshi.science.param.query.ComProjectAuditQueryVO;
import com.yiboshi.science.param.query.ComProjectGroupQueryVO;
import com.yiboshi.science.param.query.ComTalentGroupQueryVO;

import java.util.List;
import java.util.Map;

/**
 * 人才分组表
 */
public interface ComTalentGroupService extends BaseService<ComTalentGroupQueryVO, ComTalentGroupDTO, ComTalentGroup> {

    Pagination<ComTalentGroupDTO> getTalentGroupListByPage(ComTalentGroupQueryVO vo);

    ComTalentGroupDTO getGroupById(String id);

    String save(ComTalentGroupDTO group);

    String deleteByGroupId(String id);

    void CalculateGroupTalentCount(String groupId);

    void CalculateGroupExpertCount(String groupId);

    String assignTalentGroup(int systemType, List<String> GroupList, List<String> ExpertList);

    String deleteAssignGroupExpert(String id);

    boolean InsertTalentGroup(List<String> IdList, String groupId);

    boolean updataTalentGroupAdjust(List<String> IdList, String groupId);

    void processGroupTalentExpert(String groupId);

    boolean deleteGroupTalentExpert(String groupId, String projId);

    List<ComTalentKnowledgeStatisticDTO> getTalentKnowledgeStatisticByGroupId(String groupId);

    Map<String, Object> getGroupTalentInfo(List<String> groupIds);
}
