package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectResults;
import com.yiboshi.science.param.dto.ComProjectResultsDTO;
import com.yiboshi.science.param.query.ComProjectResultsQueryVO;

import java.util.List;

/**
 * 预期成果 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectResultsService extends BaseService<ComProjectResultsQueryVO, ComProjectResultsDTO, ComProjectResults> {

    /**
     * 根据对象获取任务书预期成果
     *
     * @param objectId
     * @return
     */
    List<ComProjectResultsDTO> getListByObjectId(String objectId);
    /**
     * 根据对象获取任务书预期成果
     *
     * @param objectId
     * @return
     */
    List<String> getArrayByObjectId(String objectId);
    /**
     * 根据对象获取任务书预期成果
     *
     * @param objectId
     * @return
     */
    List<String> getNameByObjectId(String objectId);
    /** 删除对象列表
     *
     * @param objectId
     */
    void deleteByObjectId(String objectId);
    /**
     * 插入预期成果
     *
     * @param resultsList
     * @param objectId
     */
    void insertList(List<String> resultsList, String objectId);
    /**
     * 插入获取空列表
     */
    List<ComProjectResultsDTO> getList();
}
