package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectCooperativeUnits;
import com.yiboshi.science.param.dto.ComProjectCooperativeUnitsDTO;
import com.yiboshi.science.param.query.ComProjectCooperativeUnitsQueryVO;

import java.util.List;

/**
 * 项目合作单位 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectCooperativeUnitsService extends BaseService<ComProjectCooperativeUnitsQueryVO, ComProjectCooperativeUnitsDTO,ComProjectCooperativeUnits> {
    /** 根据对象获取合作单位列表
     *
     * @param objectId
     * @return
     */
    List<ComProjectCooperativeUnitsDTO> getListByObjectId(String objectId, int type);
    /** 删除对象列表
     *
     * @param objectId
     */
    void deleteByObjectId(String objectId, int type);
    /** 插入合作单位
     *
     * @param list
     * @param objectId
     */
    void insertList(List<ComProjectCooperativeUnitsDTO> list, String objectId, int type);
}
