package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectAudit;
import com.yiboshi.science.entity.ComProjectConclusion;
import com.yiboshi.science.param.dto.ComProjectConclusionDTO;
import com.yiboshi.science.param.dto.DataStatisticsDTO;
import com.yiboshi.science.param.query.ComProjectConclusionQueryVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 结题信息表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectConclusionService extends BaseService<ComProjectConclusionQueryVO, ComProjectConclusionDTO, ComProjectConclusion> {

    /**
     * 根据项目id获取结题信息
     *
     * @param projId 查询条件
     */
    ComProjectConclusionDTO getByProjId(String projId);
    /**
     * 保存项目结题信息
     *
     * @param comProjectConclusionDTO
     * @return
     */
    String save(ComProjectConclusionDTO comProjectConclusionDTO);
    /**
     * 保存项目结题信息
     *
     * @param comProjectConclusionDTO
     * @return
     */
    String saveThesis(ComProjectConclusionDTO comProjectConclusionDTO, String auditUnitId);
    /**
     *  上报
     *
     * @param
     * @return
     */
    String report(String projId,String auditUnitId,String treeCode);
    /**
     *  项目结题审核
     *
     * @param e
     * @return
     */
    String conclusionAudit(ComProjectAudit e);

    /**
     *  论文审核
     *
     * @param e
     * @return
     */
    String thesisAudit(ComProjectAudit e);
    /**
     * 创建结题记录
     *
     * @return
     */
    void createConclusionRecord(String projId,String auditUnitId);
    /**
     * 导出PDF
     *
     * @return
     */
    void exportPdfById(HttpServletResponse response, String id)throws IOException;
    /**
     * 获取统计数据
     *
     * @return
     */
    DataStatisticsDTO getCount(ComProjectConclusionDTO e);
}



