package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectAuditNote;
import com.yiboshi.science.param.dto.ComProjectAuditNoteDTO;
import com.yiboshi.science.param.query.ComProjectAuditNoteQueryVO;

import java.util.Date;
import java.util.List;

/**
 * 审核表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectAuditNoteService extends BaseService<ComProjectAuditNoteQueryVO, ComProjectAuditNoteDTO, ComProjectAuditNote> {
    /**
     * 获取审核记录
     *
     * @param reportObjectId 审核对象
     * @param auditUnitId    审核单位
     * @param showIndex      审核序号
     * @return
     */
    ComProjectAuditNote getAuditNote(String reportObjectId, String auditUnitId,Integer auditType, Integer auditMethod, Integer showIndex);

    /** 插入审核记录
     *
     * @return
     */
    void insertAuditNote(Integer reportYear, Integer auditType, String auditObjectId, Integer auditMethod, String auditUnitId, String auditContent, Integer auditResult, Date auditDate, Integer unitLevel, Integer showIndex,String comPerson);
    /**
     * 更新审核记录
     *
     * @param id
     * @param auditResult
     * @param auditContent
     */
    void updateAuditNote(String id, Integer auditResult, String auditContent, Integer showIndex,String comPerson,Date auditDate,Integer reportYear,String auditUnitId,Integer auditType,Integer auditMethod);

    /**
     * 获取审核记录列表
     *
     * @param objectId
     * @return
     */
    List<ComProjectAuditNoteDTO> getListByObjectId(String objectId);

    /**
     * 初始化控件值
     *
     * @param budgetList
     * @return
     */
    List<ComProjectAuditNoteDTO> auditNoteInit(List<ComProjectAuditNoteDTO> budgetList);
}
