package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComManager;
import com.yiboshi.science.param.dto.ComManagerDTO;
import com.yiboshi.science.param.dto.ComPersonDTO;
import com.yiboshi.science.param.dto.ComUnitDTO;
import com.yiboshi.science.param.query.ComManagerQueryVO;

import java.util.List;

/**
 * 单位管理员表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComManagerService extends BaseService<ComManagerQueryVO, ComManagerDTO, ComManager> {

    /**
     * 功能:根据单位id获取单位管理员
     *
     * @param unitId 输入值
     */
    List<ComPersonDTO> getManagerListByUnitId(String unitId);
    /**
     * 注册管理员
     *
     * @param unitDTO
     * @return
     */
    String registerManager(ComUnitDTO unitDTO);

    /**
     * 添加单位管理员
     */
    String createManager(ComManagerDTO dto);
    /**
     * 功能:修改管理员状态
     *
     * @param id 输入值
     */
    String updateManagerState(String id, Integer personState);

    /**
     * 添加单位管理员
     */
    String addManagerByList(List<ComPersonDTO> managers, String unitId, String roleId);

    /**
     * 移除单位管理员
     */
    String deleteManagerById(ComPersonDTO dto);

    /**
     * 更改管理员角色
     *
     * @param unitId 值
     * @return
     */
    void updateManagerRole(String unitId, String roleId);
}
