package com.yiboshi.science.rest.v1;


import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.entity.ComProjectKpit;
import com.yiboshi.science.param.dto.ComProjectKpitDTO;
import com.yiboshi.science.param.dto.ProjectKPIStatisticDTO;
import com.yiboshi.science.param.query.ComProjectKpitQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.ComProjectKpitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "com-project-kpit", description = "项目表")
@RestController
@RequestMapping("/v1/science-admin/com-project-kpit")
public class ComProjectKpitController extends BaseController<ComProjectKpitService, ComProjectKpitQueryVO, ComProjectKpitDTO, ComProjectKpit> {

    @Autowired
    private ComProjectKpitService comProjectKpitService;

    @ApiOperation(value = "获取未分配的项目列表", httpMethod = "GET", notes = "获取未分配的项目列表")
    @GetMapping
    @RequestMapping("/getProjectKpitStatistic")
    public ResponseDataModel<ProjectKPIStatisticDTO> getProjectKpitStatistic() {
        List<ComProjectKpitDTO> ProjectKPIList = comProjectKpitService.getProjectKpitStatistic();
        ProjectKPIStatisticDTO dto = new ProjectKPIStatisticDTO();
        dto.setTotalRowSpan(ProjectKPIList.size() + 2);
        dto.setThreeLevel(ProjectKPIList);
        return ResponseDataModel.ok(dto);
    }

}
