package com.yiboshi.science.rest.v1;


import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComExpertGroup;
import com.yiboshi.science.param.dto.ComExpertGroupDTO;
import com.yiboshi.science.param.query.ComExpertGroupQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.ComExpertGroupAssignService;
import com.yiboshi.science.service.ComExpertGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@Api(tags = "com-expert-spec", description = "项目分配表")
@RestController
@RequestMapping("/v1/science-admin/com-expert-group")
public class ComExpertGroupController extends BaseController<ComExpertGroupService, ComExpertGroupQueryVO, ComExpertGroupDTO, ComExpertGroup> {
    @Autowired
    private ComExpertGroupService comExpertGroupService;

    @Autowired
    private ComExpertGroupAssignService ComExpertGroupAssignService;
    /**
     * 功能:分页查询
     *
     * @param vo 查询条件
     */
    @ApiOperation(value = "分页查询", httpMethod = "GET", notes = "根据参数获取列表")
    @GetMapping
    @RequestMapping("/getAssignExpertGroupList")
    public ResponseDataModel<Pagination<ComExpertGroupDTO>> getAssignExpertGroupList(@Validated ComExpertGroupQueryVO vo, BindingResult bindingResult) {
        Pagination<ComExpertGroupDTO> page = comExpertGroupService.getListByPage(vo);
        if (null != page && null != page.getDataList() && page.getDataList().size() > 0) {
            page.getDataList().forEach((e) -> {
              e.setAssignInfo(ComExpertGroupAssignService.getAssignCount(e.getId()));
            });
        }
        return ResponseDataModel.ok(page);
    }

    @ApiOperation(value = "获取专家组", httpMethod = "GET", notes = "获取专家组")
    @GetMapping
    @RequestMapping("/getExpertGroupList")
    public ResponseDataModel<List<ComExpertGroupDTO>> getExpertGroupList() {
        return ResponseDataModel.ok(comExpertGroupService.getExpertGroupList());
    }
}
