package com.yiboshi.science.param.query;

import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 * 试制设备预算明细表VO
 * 
 * @author xujun
 * @version 2024-12-16
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "试制设备预算明细表VO")
public class ComProjectManufactureQueryVO extends PaginationVO{

    @ApiModelProperty(value = "对象id（项目Id/任务书Id）", position = 2 )
    @Length(max=36, message = "对象id（项目Id/任务书Id）不能大于36")
    private String objectId;
    /** 设备仪器名称 */
    @ApiModelProperty(value = "设备仪器名称", position = 1 )
    @Length(max=100, message = "设备仪器名称不能大于100")
    private String name;
    /** 功能和技术指标 */
    @ApiModelProperty(value = "功能和技术指标", position = 1 )
    @Length(max=200, message = "功能和技术指标不能大于200")
    private String functionTarget;
    /** 单价(万元/台套) */
    @ApiModelProperty(value = "单价(万元/台套)", position = 3)
    private BigDecimal unitPrice;
    /** 数量 */
    @ApiModelProperty(value = "数量", position = 1)
    private Integer quantity;
    /** 金额 */
    @ApiModelProperty(value = "金额", position = 3)
    private BigDecimal totalBudget;

    /** 财政资金 */
    @ApiModelProperty(value = "财政资金", position = 3)
    private BigDecimal fundAmount;
    /** 自筹资金 */
    @ApiModelProperty(value = "自筹资金", position = 3)
    private BigDecimal selfAmount;

    /** 试制单位 */
    @ApiModelProperty(value = "试制单位", position = 1)
    @Length(max=100, message = "试制单位不能大于100")
    private String manufactureUnit;
    /** 安置单位 */
    @ApiModelProperty(value = "安置单位", position = 1)
    @Length(max=100, message = "安置单位不能大于100")
    private String storageUnit;
}