package com.yiboshi.science.param.query;

import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询项目绩效指标表VO")
public class ComProjectKpitQueryVO extends PaginationVO {

    /** 级别Id */
    @ApiModelProperty(value = "级别Id", position = 8)
    @Length(max=36, message = "级别Id不能大于36")
    private String levelId;
    /** 类型Id */
    @ApiModelProperty(value = "类型Id", position = 7)
    private Integer typeId;
    /** 父Id */
    @ApiModelProperty(value = "父Id", position = 8)
    @Length(max=36, message = "父Id不能大于36")
    private String parentId;
    /** 绩效类型名称 */
    @ApiModelProperty(value = "绩效类型名称", position = 1 )
    @Length(max=200, message = "绩效类型名称不能大于200")
    private String kpitName;
    /** 指标值 */
    @ApiModelProperty(value = "指标值", position = 7)
    private Integer targetValue;
    /** 绩效标准 */
    @ApiModelProperty(value = "绩效标准", position = 7)
    private Integer performanceStandard;
    /** 显示顺序 */
    @ApiModelProperty(value = "显示顺序", position = 7)
    private Integer displayOrder;
    /** 一级指标显示 */
    @ApiModelProperty(value = "一级指标显示", position = 7)
    private boolean oneDisplay;
    /** 二级指标显示 */
    @ApiModelProperty(value = "二级指标显示", position = 7)
    private boolean towDisplay;
    /** 一级指标行合并数 */
    @ApiModelProperty(value = "一级指标行合并数", position = 7)
    private Integer oneRowSpan;
    /** 二级指标行合并数 */
    @ApiModelProperty(value = "二级指标行合并数", position = 7)
    private Integer towRowSpan;

}
