package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 任务书预期成果表DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "任务书预期成果表DTO")
public class ComTaskTargetDTO extends BaseDTO {
    /** 任务书Id */
    @ApiModelProperty(value = "任务书Id")
    private String testId;
    /** 预期成果Id (参数表获取) */
    @ApiModelProperty(value = "预期成果Id (参数表获取)", position = 1)
    private String targetId;
    /** 预期成果 */
    @ApiModelProperty(value = "预期成果", position = 2)
    private String result;
    /** 数量 */
    @ApiModelProperty(value = "数量", position = 3)
    private Integer resultCount;


    /** 预期成果名称 */
    @ApiModelProperty(value = "预期成果名称", position = 5)
    private String targetName;
    /** 是否选中 */
    @ApiModelProperty(value = "是否选中", position = 6)
    private boolean Checked;
    /** 排序号 */
    @ApiModelProperty(value = "排序号", position = 7)
    private Integer OrderNo;


}