package com.yiboshi.science.param.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "项目组分配表DTO")
public class ComProjectGroupAssignDTO extends BaseDTO {

    /** 项目组Id */
    @ApiModelProperty(value = "项目组Id", position = 1)
    @Length(max=36, message = "项目组Id不能大于36")
    private String groupId;

    /** 专家Id */
    @ApiModelProperty(value = "专家Id", position = 2)
    @Length(max=36, message = "专家Id不能大于36")
    private String expertId;

    /** 专家类型（1技术专家、2财务专家） */
    @ApiModelProperty(value = "专家类型", position = 3)
    private Integer expertType;

    /** 备注 */
    @ApiModelProperty(value = "备注", position = 3)
    @Length(max=65535, message = "备注不能大于65535")
    private String remark;

    /** 证件号 */
    @ExcelProperty("证件号")
    @ApiModelProperty(value = "证件号", position = 4)
    private String certId;

    /** 姓名 */
    @ExcelProperty("姓名")
    @ApiModelProperty(value = "姓名", position = 5)
    private String personName;

    /** 性别 */
    @ExcelProperty("性别")
    @ApiModelProperty(value = "性别", position = 6)
    private String sex;

    /** 出生日期 */
    @ApiModelProperty(value = "出生日期", position = 7)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;

    /** 职称 */
    @ApiModelProperty(value = "职称", position = 8)
    private String title;

    /** 职称 */
    @ExcelProperty("职称")
    @ApiModelProperty(value = "职称", position = 9)
    private String titleName;

    /** 学位 */
    @ApiModelProperty(value = "学位", position = 10)
    private String degree;

    /** 学位 */
    @ApiModelProperty(value = "学位", position = 11)
    private String degreeName;

    /** 邮箱 */
    @ApiModelProperty(value = "邮箱", position = 12)
    private String email;

    /** 电话号码 */
    @ApiModelProperty(value = "电话号码", position = 13)
    private String mobile;

    /** 单位 */
    @ApiModelProperty(value = "单位", position = 14)
    private String unitName;

    /** 专家单位 */
    @ApiModelProperty(value = "专家单位", position = 14)
    private String workUnit;

    /** 项目组名称 */
    @ApiModelProperty(value = "项目组名称", position = 17)
    private String groupName;

    /** 评审专业 */
    @ApiModelProperty(value = "评审专业", position = 13)
    private List<ComExpertSpecDTO> specList;

    /** 评审明细 */
    @ApiModelProperty(value = "评审明细", position = 14)
    private List<ComProjectAssignDTO> projAssignList;

}
