package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 *  结题信息表DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "结题信息表DTO")
public class ComProjectConclusionDTO extends BaseDTO {
    /** 项目Id */
    @ApiModelProperty(value = "项目Id", position = 1)
    @Length(max=36, message = "项目Id不能大于36")
    private String projId;
    /** 结题年度 */
    @ApiModelProperty(value = "结题年度", position = 6 )
    private Integer year;
    /** 计划类别 */
    @ApiModelProperty(value = "计划类别", position = 2)
    @Length(max=50, message = "计划类别不能大于50")
    private String planCategory;
    /** 研究周期(开始) */
    @ApiModelProperty(value = "研究周期(开始)", position = 3 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date startDate;
    /** 研究周期(结束) */
    @ApiModelProperty(value = "研究周期(结束)", position = 4)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date endDate;
    /** 状态 0 未填报 1 起草 10 待上报 20已上报 */
    @ApiModelProperty(value = "状态 0 未填写 1 起草 10 填写完成  20已上报", position = 5 )
    private Integer state;
    /** 研究或推广内容完成情况 */
    @ApiModelProperty(value = "研究或推广内容完成情况", position = 6)
    @Length(max=36, message = "研究或推广内容完成情况不能大于36")
    private String promotionContent;
    /** 研究或推广目标实现情况 */
    @ApiModelProperty(value = "研究或推广目标实现情况", position = 7)
    @Length(max=36, message = "研究或推广目标实现情况不能大于36")
    private String promotionTarget;
    /** 研究水平的自我评价 */
    @ApiModelProperty(value = "研究水平的自我评价", position = 8)
    @Length(max=36, message = "研究水平的自我评价不能大于36")
    private String selfEvaluation;
    /** 取得成果情况 */
    @ApiModelProperty(value = "取得成果情况", position =9)
    @Length(max=36, message = "取得成果情况不能大于36")
    private String achievingResults;
    /** 结余 */
    @ApiModelProperty(value = "结余", position =9)
    private BigDecimal balance;
    /** 研究或推广内容及结果简介 */
    @ApiModelProperty(value = "研究或推广内容及结果简介", position =10)
    @Length(max=2147483647, message = "研究或推广内容及结果简介不能大于2147483647")
    private String researchContent;
    /** 下一步的工作打算 */
    @ApiModelProperty(value = "下一步的工作打算", position = 11)
    @Length(max=1000, message = "下一步的工作打算不能大于1000")
    private String workPlan;
    /** 延期报告 */
    @ApiModelProperty(value = "延期报告", position = 12)
    @Length(max=1000, message = "延期报告不能大于1000")
    private String extensionReport;
    /** 纸质编号 */
    @ApiModelProperty(value = "纸质编号", position = 6 )
    private String paperNumber;
    /** 项目合同编号 */
    @ApiModelProperty(value = "项目合同编号", position = 6 )
    private String contractNo;
    /** 结题审核人 */
    @ApiModelProperty(value = "结题审核人", position = 6 )
    private String auditPersonName;
    /** 结题日期 */
    @ApiModelProperty(value = "结题日期", position = 10)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date conclusionDate;
    /** 是否盖章 1是 0否*/
    @ApiModelProperty(value = "是否盖章 1是 0否", position = 5 )
    private Integer isStamp;
    /** 论文上传状态 0 未上传  1待审核 10审核通过 30 返回修改  20审核不通过*/
    @ApiModelProperty(value = "论文上传状态 0 未上传  1待审核 10审核通过 30 返回修改  20审核不通过", position = 5 )
    private Integer thesisState;

    /** 状态 */
    @ApiModelProperty(value = "状态", position = 1 )
    private String stateName;

    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 1 )
    @Length(max=50, message = "项目名称不能大于50")
    private String projName;
    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 2 )
    @Length(max=100, message = "项目编号不能大于100")
    private String projNo;
    /** 申报年度 */
    @ApiModelProperty(value = "申报年度", position = 6 )
    private Integer reportYear;
    /** 项目状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准立项,50 批准立项 */
    @ApiModelProperty(value = "项目状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准立项,50 批准立项", position = 7 )
    private Integer projState;
    /** 项目开始时间 */
    @ApiModelProperty(value = "项目开始时间", position = 10 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date projStartDate;
    /** 项目结束时间 */
    @ApiModelProperty(value = "项目结束时间", position = 11 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date projEndDate;

    /** 申请人 */
    @ApiModelProperty(value = "申请人", position = 12)
    private String appPersonName;
    /** 联系电话 */
    @ApiModelProperty(value = "联系电话", position = 12)
    private String telephone;

    /** 申请人所在单位名称 */
    @ApiModelProperty(value = "申请人所在单位名称", position = 12)
    private String appUnitName;

    @ApiModelProperty(value = "申报人Id", position = 9 )
    @Length(max=36, message = "申报人Id不能大于36")
    private String appPersonId;
    /** 申报单位Id */
    @ApiModelProperty(value = "申报单位Id", position = 8 )
    @Length(max=36, message = "申报单位Id不能大于36")
    private String appUnitId;

    /** 论文列表 */
    private List<ComConclusionThesisDTO> thesisList;
    /** 主要研究人员列表 */
    private List<ComConclusionResearchersDTO> researchersList;
    /** 经费决算列表-拔款 */
    private List<ComConclusionFundsDTO> grant;
    /** 经费决算列表-其它途径筹资 */
    private List<ComConclusionFundsDTO> finance;
    /** 经费决算列表-主要支出项目 */
    private List<ComConclusionFundsDTO> spending;
    /** 附件列表 */
    private List<ComFileDTO> fileList;
    /** 验收材料目录表列表 */
    private List<ComConclusionCatalogDTO> catalogList;

    private List<ComProjectAuditNoteDTO> auditList;

}