package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 经费申请表（任务书/项目申请书）DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "经费申请表（任务书/项目申请书）DTO")
public class ComProjectBudgetDTO extends BaseDTO {
    /** 经费类别Id (参数表获取) */
    @ApiModelProperty(value = "经费类别Id (参数表获取)", position = 1 )
    private String budgetId;
    /** 对象id（项目Id/任务书Id） */
    @ApiModelProperty(value = "对象id（项目Id/任务书Id）", position = 2 )
    private String objectId;
    /** 金额 */
    @ApiModelProperty(value = "金额", position = 3)
    private BigDecimal totalBudget;
    /** 申请专项经费(临床科技项目) */
    @ApiModelProperty(value = "申请专项经费", position = 4)
    private BigDecimal applyFunds;
    /** 自筹经费(临床科技项目) */
    @ApiModelProperty(value = "自筹经费", position = 5)
    private BigDecimal selfFunds;
    /** 计算依据/备注 */
    @ApiModelProperty(value = "计算依据/备注", position = 6)
    private String calculationBasis;


    @ApiModelProperty(value = "经费类别", position = 1)
    private String budgetName;
    @ApiModelProperty(value = "禁用 启用", position = 1)
    private String level;
    @ApiModelProperty(value = "数据总和来源", position = 1)
    private Integer[] source;
    @ApiModelProperty(value = "禁用 启用", position = 1)
    private String code;
    @ApiModelProperty(value = "控件类型", position = 1)
    private String type;

    /** 系统编码 */
    @ApiModelProperty(value = "系统编码", position = 8)
    private String systemCode;

    /** 禁用启用 */
    @ApiModelProperty(value = "禁用 启用", position = 1)
    private String disabled;

}