package com.yiboshi.science.param.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 人员表DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "人员表DTO")
public class ComPersonDTO extends BaseDTO {
    /** 证件号 */
    @ApiModelProperty(value = "证件号", position = 2)
    private String certId;
    /** 证件类型 (参数表获取) */
    @ApiModelProperty(value = "证件类型 (参数表获取)", position = 3)
    private String certType;
    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 4)
    private String personName;
    /** 性别 */
    @ApiModelProperty(value = "性别", position = 5)
    private String sex;
    /** 出生日期 */
    @ApiModelProperty(value = "出生日期", position = 6)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;
    /** 单位Id */
    @ApiModelProperty(value = "单位Id", position = 7)
    private String unitId;
    /** 人员状态 1 正常 2 注销 */
    @ApiModelProperty(value = "人员状态 1 正常 2 注销", position = 8)
    private Integer personState;
    /** 学位 */
    @ApiModelProperty(value = "学位", position = 9)
    private String degree;
    /** 最高学位授予时间 */
    @ApiModelProperty(value = "最高学位授予时间", position = 6)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date degreeTime;
    /** 最高学位授予单位 */
    @ApiModelProperty(value = "最高学位授予单位", position = 9)
    private String degreeUnit;
    /** 是否为研究生导师 */
    @ApiModelProperty(value = "是否为研究生导师", position = 8)
    private String graduateTeacher;
    /** 党派 */
    @ApiModelProperty(value = "党派", position = 9)
    private String politicalParty;
    /** 学历 */
    @ApiModelProperty(value = "学历", position = 10)
    private String education;
    /** 民族 */
    @ApiModelProperty(value = "民族", position = 11)
    private String nation;
    /** 职务 */
    @ApiModelProperty(value = "职务", position = 12)
    private String duty;
    /** 职称 */
    @ApiModelProperty(value = "职称", position = 13)
    private String title;
    /** 专业 */
    @ApiModelProperty(value = "专业", position = 14)
    private String spec;
    /** 现从事专业 */
    @ApiModelProperty(value = "现从事专业", position = 11 )
    @Length(max=36, message = "现从事专业不能大于36")
    private String profession;
    /** 邮箱 */
    @ApiModelProperty(value = "邮箱", position = 15)
    private String email;
    /** 电话号码 */
    @ApiModelProperty(value = "电话号码", position = 16)
    private String mobile;
    /** 电话 */
    @ApiModelProperty(value = "职务", position = 9 )
    @Length(max=36, message = "职务不能大于36")
    private String telephone;
    /** 传真 */
    @ApiModelProperty(value = "职务", position = 9 )
    @Length(max=36, message = "职务不能大于36")
    private String fax;
    /** 照片 */
    @ApiModelProperty(value = "照片", position = 17)
    private String photo;
    /** 住址 */
    @ApiModelProperty(value = "住址", position = 18)
    private String address;
    /** 开户银行 */
    @ApiModelProperty(value = "开户银行", position = 19 )
    private String openBank;
    /** 开户账号 */
    @ApiModelProperty(value = "开户账号", position = 20 )
    private String openAcount;
    /** 工作单位 */
    @ApiModelProperty(value = "工作单位", position = 19 )
    @Length(max=200, message = "工作单位")
    private String workUnit;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 19 )
    @Length(max=200, message = "备注不能大于200")
    private String remark;

    /** 主要研究领域 */
    @ApiModelProperty(value = "主要研究领域", position = 19 )
    @Length(max=200, message = "主要研究领域不能大于200")
    private String mainResearchAreas;

    /** 1 待审核，10 审核通过， 20 审核不通过 ，30 返回修改 */
    @ApiModelProperty(value = "审核结果", position = 25)
    private Integer auditResult;
    /** 审核内容 */
    @ApiModelProperty(value = "审核内容", position = 24 )
    private String auditContent;
    /** 审核单位*/
    @ApiModelProperty(value = "审核单位", position = 28 )
    private String auditUnit;
    /** 审核人 */
    @ApiModelProperty(value = "审核人", position = 27)
    private String auditPerson;
    /** 审核时间 */
    @ApiModelProperty(value = "审核时间", position = 26 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date auditDate;


    /** 人员状态 1 正常 2 注销 */
    @ExcelProperty("人员状态")
    @ApiModelProperty(value = "人员状态 1 正常 2 注销", position = 29)
    private String personStateName;
    /** 一级专业 */
    @ApiModelProperty(value = "一级专业", position = 39)
    private String specParentId;

    /** 单位编码 */
    @ApiModelProperty(value = "单位编码", position = 7)
    private String treeCode;

    /** 用户Id*/
    @ApiModelProperty(value = "用户Id", position = 30)
    private String userId;
    /** 用户名 */
    @ApiModelProperty(value = "用户名", position = 31)
    private String username;
    /** 密码 */
    @ApiModelProperty(value = "密码", position = 32)
    private String password;
    /** 用户角色Id*/
    @ApiModelProperty(value = "用户角色Id", position = 30)
    private String userRoleId;
    /** 用户角色状态*/
    @ApiModelProperty(value = "用户角色状态", position = 30)
    private Integer state;
    /** 用户角色状态*/
    @ApiModelProperty(value = "用户角色状态", position = 30)
    private String stateName;

    /** 职称 */
    @ApiModelProperty(value = "职称", position = 33)
    private String titleName;
    /** 学位 */
    @ApiModelProperty(value = "学位", position = 34)
    private String degreeName;
    /** 学历 */
    @ApiModelProperty(value = "学历", position = 35)
    private String educationName;
    /** 职务 */
    @ApiModelProperty(value = "职务", position = 36)
    private String dutyName;
    /** 民族 */
    @ApiModelProperty(value = "民族", position = 37)
    private String nationName;
    /** 工作单位 */
    @ApiModelProperty(value = "工作单位", position = 38)
    private String unitName;
    /** 单位类型 */
    @ApiModelProperty(value = "单位类型", position = 41)
    private Integer unitType;
    /** 专业 */
    @ApiModelProperty(value = "专业", position = 40)
    private String specName;
    /** 现从事专业 */
    @ApiModelProperty(value = "现从事专业", position = 40)
    private String professionName;

    /** 验证码 */
    @ApiModelProperty(value = "验证码", position = 42)
    private String code;
    /** 短信发送对象 1 单位 2 个人 */
    @ApiModelProperty(value = "验证码", position = 43)
    private Integer send;
}