package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import com.yiboshi.science.entity.AssignCount;
import com.yiboshi.science.entity.SelectListItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "专家项目分配表DTO")
public class ComExpertGroupDTO extends BaseDTO {
    /** 批次Id */
    @ApiModelProperty(value = "批次Id", position = 2)
    @Length(max=36, message = "批次Id不能大于36")
    private String batchId;
    /** 专家组名称 */
    @ApiModelProperty(value = "专家组名称", position = 3)
    @Length(max=200, message = "专家组名称不能大于200")
    private String name;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 4)
    @Length(max=200, message = "备注不能大于200")
    private String remark;

    /** 批次名称 */
    @ApiModelProperty(value = "批次名称", position = 5)
    @Length(max=200, message = "批次名称不能大于200")
    private String batchName;
    /** 年度 */
    @ApiModelProperty(value = "年度", position = 6)
    private Integer year;
    /** 批次 */
    @ApiModelProperty(value = "批次", position = 7 )
    private Integer batch;
    /** 项目分配信息 */
    @ApiModelProperty(value = "批次", position = 8)
    private List<AssignCount> assignInfo;
    /** 专家组成员 */
    @ApiModelProperty(value = "专家组成员", position = 9)
    private List<SelectListItem> members;

}
