package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "评审表DTO")
public class ComEvaluationDTO extends BaseDTO {
    /** 评审表名称 */
    @ApiModelProperty(value = "评审表名称", position = 2)
    private String name;
    /** 总分 */
    @ApiModelProperty(value = "总分", position = 3)
    private BigDecimal score;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 4)
    @Length(max=200, message = "备注长度不能大于200")
    private String remark;
}
