package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

/**
 * 附件表DTO
 * 
 * @author lkl
 * @version 2021-08-25
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "附件表DTO")
public class ComDownloadDTO extends BaseDTO {
    /** 项目ID */
    @ApiModelProperty(value = "项目ID", position = 4)
    private String projId;
    /** 申请编号 */
    @ApiModelProperty(value = "申请编号", position = 4)
    private String appNo;
    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 2)
    private String projNo;
    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 1)
    private String projName;
    /** 申报年度 */
    @ApiModelProperty(value = "申报年度", position = 6)
    private Integer reportYear;
    /** URL */
    @ApiModelProperty(value = "URL", position = 1)
    private String downloadUrl;
    /** 转换文件URL */
    @ApiModelProperty(value = "转换文件URL", position = 2)
    private String convertUrl;
    /** 附件名 */
    @ApiModelProperty(value = "附件名", position = 2)
    @Length(max=100, message = "附件名长度不能大于100")
    private String fileName;
    /** 后缀 */
    @ApiModelProperty(value = "后缀", position = 3)
    private String extension;
    /** 附件说明 */
    @ApiModelProperty(value = "附件说明", position = 3)
    private String fileExplain;
    /** 批量审核Id */
    List<String> idList;
}