package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 * 系统角色表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "系统角色表VO")
public class SystemRole extends BaseEntity {

    /** 名称 */
    @ApiModelProperty(value = "名称", position = 1 )
    @Length(max=100, message = "名称不能大于100")
    private String name;
    /** 角色Id */
    @ApiModelProperty(value = "角色Id", position = 2 )
    private Integer roleId;
    /** 权限 */
    @ApiModelProperty(value = "权限", position = 2 )
    private String authority;
}