package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 * 请求异常日志表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "请求异常日志表VO")
public class LogsRequestException extends BaseEntity {

    /** ip地址 */
    @ApiModelProperty(value = "ip地址", position = 1 )
    @Length(max=30, message = "ip地址不能大于30")
    private String ipAddress;
    /** 用户名 */
    @ApiModelProperty(value = "用户名", position = 2 )
    @Length(max=100, message = "用户名不能大于100")
    private String username;
    /** 请求次数 */
    @ApiModelProperty(value = "请求次数", position = 3 )
    private Integer requestCount;
    /** 请求类型 1 IP 2 用户  */
    @ApiModelProperty(value = "请求类型 1 IP 2 用户 ", position = 4 )
    private Integer requestType;

}