package com.yiboshi.science.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 人才团队成员表
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("com_talent_members")
@ApiModel(description = "人才团队成员表VO")
public class ComTalentMembers extends BaseEntity {
    
    /** 人才申请ID */
    @ApiModelProperty(value = "人才申请ID", position = 1)
    @Length(max=36, message = "人才申请ID不能大于36")
    private String talentId;
    
    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 2)
    @Length(max=30, message = "姓名不能大于30")
    private String name;
    
    /** 性别 */
    @ApiModelProperty(value = "性别", position = 3)
    @Length(max=2, message = "性别不能大于2")
    private String sex;
    
    /** 出生日期 */
    @ApiModelProperty(value = "出生日期", position = 4)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date birthday;
    
    /** 专业 */
    @ApiModelProperty(value = "专业特长", position = 5)
    @Length(max=200, message = "专业特长不能大于200")
    private String spec;
    
    /** 职称 */
    @ApiModelProperty(value = "职称", position = 6)
    @Length(max=50, message = "职称不能大于50")
    private String title;
    
    /** 工作单位 */
    @ApiModelProperty(value = "工作单位", position = 7)
    @Length(max=100, message = "工作单位不能大于100")
    private String workUnit;
    
    /** 项目分工 */
    @ApiModelProperty(value = "项目分工", position = 8)
    @Length(max=100, message = "项目分工不能大于100")
    private String projWork;
    
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 9)
    @Length(max=200, message = "备注不能大于200")
    private String remark;

    /** 排序 */
    @ApiModelProperty(value = "排序", position = 10)
    private Integer showIndex;
} 