package com.yiboshi.science.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 * 人才专家分配明细表
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("com_talent_assign")
@ApiModel(description = "人才专家分配明细表")
public class ComTalentAssign extends BaseEntity {

    /** 专家Id */
    @ApiModelProperty(value = "专家Id", position = 1)
    @Length(max=36, message = "专家Id不能大于36")
    private String expertId;

    /** 人才Id */
    @ApiModelProperty(value = "人才Id", position = 2)
    @Length(max=36, message = "人才Id不能大于36")
    private String talentId;

    /** 分配年度 */
    @ApiModelProperty(value = "分配年度", position = 3)
    private Integer assignYear;

    /** 审核状态（0 未评审 1 保存 2 已提交） */
    @ApiModelProperty(value = "审核状态（0 未评审 1 保存 2 已提交）", position = 11)
    private Integer auditState;

    /** 总分 */
    @ApiModelProperty(value = "总分", position = 9)
    private BigDecimal totalScore;

    /** 备注 */
    @ApiModelProperty(value = "备注", position =10)
    @Length(max=65535, message = "备注不能大于65535")
    private String remark;

}
