package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "项目分组表VO")
public class ComProjectGroup extends BaseEntity {
    @ApiModelProperty(value = "项目组名称", position = 1)
    @Length(max=60, message = "项目组名称不能大于60")
    private String groupName;

    @ApiModelProperty(value = "项目分组年度", position = 2)
    private Integer groupYear;

    @ApiModelProperty(value = "项目组排序", position = 2)
    private Integer displayOrder;

    /** 学科Id */
    @ApiModelProperty(value = "学科Id", position = 3)
    @Length(max=36, message = "学科Id不能大于36")
    private String knowledgeId;

    @ApiModelProperty(value = "项目分组中的项目数", position = 4)
    private Integer projCount;

    @ApiModelProperty(value = "项目分组中的专家数", position = 5)
    private Integer expertCount;

    /** 分配状态 0未分配 1已分配 */
    @ApiModelProperty(value = "分配状态", position = 6)
    private Integer assignState;

    /** 备注 */
    @ApiModelProperty(value = "备注", position = 7)
    @Length(max=200, message = "备注不能大于200")
    private String remark;
}
