package com.yiboshi.science.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 申报人科研学术成绩表
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "申报人科研学术成绩表VO")
public class ComPersonScientificGain extends BaseEntity {

    /** 人才申请Id */
    @ApiModelProperty(value = "人才申请Id", position = 2)
    @Length(max=36, message = "人才申请Id不能大于36")
    private String talentId;

    /** 成果类型(系统参数) */
    @ApiModelProperty(value = "成果类型", position = 1)
    @Length(max=36, message = "成果类型不能大于36")
    private String gainType;
    
    /** 成果日期 */
    @ApiModelProperty(value = "成果日期", position = 2)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date gainDate;
    
    /** 成果名称 */
    @ApiModelProperty(value = "成果名称", position = 3)
    @Length(max=100, message = "成果名称不能大于100")
    private String gainName;
    
    /** 成果描述 */
    @ApiModelProperty(value = "成果描述", position = 4)
    @Length(max=200, message = "成果描述不能大于200")
    private String gainDescription;
    
    /** 成果备注 */
    @ApiModelProperty(value = "成果备注", position = 5)
    @Length(max=200, message = "成果备注不能大于200")
    private String gainRemark;

    /** 排序 */
    @ApiModelProperty(value = "排序", position = 6)
    private Integer showIndex;
} 