package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "专家评审专业表")
public class ComExpertGroup extends BaseEntity {
    /** 批次Id */
    @ApiModelProperty(value = "批次Id", position = 1)
    @Length(max=36, message = "批次Id不能大于36")
    private String batchId;
    /** 专家组名称 */
    @ApiModelProperty(value = "专家组名称", position = 1)
    @Length(max=200, message = "专家组名称不能大于200")
    private String name;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 1)
    @Length(max=200, message = "备注不能大于200")
    private String remark;
}
