package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "专家表")
public class ComExpert extends BaseEntity {
    /** 人员Id */
    @ApiModelProperty(value = "人员Id", position = 1)
    @Length(max=36, message = "人员Id不能大于36")
    private String personId;
    /** 专家状态  1 启用  2 停用 */
    @ApiModelProperty(value = "专家状态  1 启用  2 停用", position = 7 )
    private Integer expertState;
    /** 上报状态  1 未上报  2 已上报 */
    @ApiModelProperty(value = "上报状态  1 未上报  2 已上报", position = 7 )
    private Integer reportState;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 19 )
    @Length(max=200, message = "备注不能大于200")
    private String remark;
}
