package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.ComProjectGroupDetail;
import com.yiboshi.science.param.dto.ComProjectGroupDetailDTO;
import com.yiboshi.science.param.query.ComProjectGroupDetailQueryVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;


public interface ComProjectGroupDetailDAO extends BaseMapper<ComProjectGroupDetail>, BaseDAO<ComProjectGroupDetailQueryVO, ComProjectGroupDetailDTO, ComProjectGroupDetail> {
    ComProjectGroupDetailDTO getProjectGroupDetailByGP(@Param("groupId") String groupId, @Param("projId") String projId);

    List<ComProjectGroupDetailDTO> getProjectDetailList(String groupId);

    List<ComProjectGroupDetailDTO> getProjectDetailList2(String groupId);

    Page<ComProjectGroupDetailDTO> getProjectDetailListbyPage(Page<ComProjectGroupDetailQueryVO> page, @Param("ew") Wrapper<ComProjectGroupDetailQueryVO> queryWrapper);

    List<ComProjectGroupDetailDTO> getProjectListByGroupIds(@Param("groupIds") List<String> groupList);
    List<ComProjectGroupDetailDTO> getMembersListByGroupIds(@Param("groupIds") List<String> groupList);
}
