package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.ComProject;
import com.yiboshi.science.param.dto.ComProjectDTO;
import com.yiboshi.science.param.dto.DataStatisticsDTO;
import com.yiboshi.science.param.query.ComProjectQueryVO;
import org.apache.ibatis.annotations.Param;

/**
 * 项目表 DAO
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectDAO extends BaseMapper<ComProject>, BaseDAO<ComProjectQueryVO,ComProjectDTO,ComProject> {
    String getProjectNo (String Code);
    DataStatisticsDTO getCount(@Param("ew") Wrapper<ComProject> queryWrapper);
    ComProjectDTO getById(String id);
    DataStatisticsDTO getProjectReportCountByGov(String treeCode);
    DataStatisticsDTO getProjectReportCountByUnitId(String appUnitId);
}
