package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComTalentMembersDAO;
import com.yiboshi.science.entity.ComTalentMembers;
import com.yiboshi.science.param.dto.ComTalentMembersDTO;
import com.yiboshi.science.param.query.ComTalentMembersQueryVO;
import com.yiboshi.science.service.ComTalentMembersService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 人才团队成员表 Service 实现类
 * @author xujun
 * @version 2025-03-12
 */

@Service
@AllArgsConstructor
public class ComTalentMembersServiceImpl extends BaseServiceImpl<ComTalentMembersDAO, ComTalentMembersQueryVO, ComTalentMembersDTO, ComTalentMembers> implements ComTalentMembersService {

    @Autowired
    private ComTalentMembersDAO comTalentMembersDAO;

    @Override
    protected void setCriteriaForQuery(ComTalentMembersQueryVO vo, QueryWrapper<ComTalentMembersQueryVO> criteria) {

    }

    public void insertList(List<ComTalentMembersDTO> list, String TalentId) {
        ComTalentMembers menber = new ComTalentMembers();
        menber.setTalentId(TalentId);
        this.delete(menber);

        if (null != list) {
            List<ComTalentMembers> iList = new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                ComTalentMembers item = convert2Entity(list.get(i));
                item.setTalentId(TalentId);
                iList.add(item);
            }
            this.insertBatch(iList);
        }
    }

    public List<ComTalentMembersDTO> getListByTalentId(String talentId) {
        return comTalentMembersDAO.getListByTalentId(talentId);
    }

    public void deleteByObjectId(String objectId) {
        ComTalentMembers e = new ComTalentMembers();
        e.setTalentId(objectId);
        this.delete(e);
    }
}
