package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectAuditNoteDAO;
import com.yiboshi.science.entity.ComProjectAuditNote;
import com.yiboshi.science.enumeration.CommonEnum;
import com.yiboshi.science.param.dto.ComProjectAuditNoteDTO;
import com.yiboshi.science.param.query.ComProjectAuditNoteQueryVO;
import com.yiboshi.science.service.ComProjectAuditNoteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 审核表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComProjectAuditNoteServiceImpl extends BaseServiceImpl<ComProjectAuditNoteDAO, ComProjectAuditNoteQueryVO, ComProjectAuditNoteDTO, ComProjectAuditNote> implements ComProjectAuditNoteService {

    @Autowired
    private ComProjectAuditNoteDAO comProjectAuditNoteDAO;

    @Override
    protected void setCriteriaForQuery(ComProjectAuditNoteQueryVO vo, QueryWrapper<ComProjectAuditNoteQueryVO> criteria) {
        if (Objects.nonNull(vo.getReportYear())) {
            criteria.eq("report_year", vo.getReportYear());
        }
        if (Objects.nonNull(vo.getAuditType())) {
            criteria.eq("audit_type", vo.getAuditType());
        }
        if (Objects.nonNull(vo.getAuditObjectId())) {
            criteria.eq("audit_object_id", vo.getAuditObjectId());
        }
        if (Objects.nonNull(vo.getAuditUnitId())) {
            criteria.eq("audit_unit_id", vo.getAuditUnitId());
        }
        if (Objects.nonNull(vo.getAuditContent())) {
            criteria.eq("audit_content", vo.getAuditContent());
        }
        if (Objects.nonNull(vo.getAuditResult())) {
            criteria.eq("audit_result", vo.getAuditResult());
        }
        if (Objects.nonNull(vo.getAuditDate())) {
            criteria.eq("audit_date", vo.getAuditDate());
        }
        if (Objects.nonNull(vo.getShowIndex())) {
            criteria.eq("show_index", vo.getShowIndex());
        }
        if (Objects.nonNull(vo.getUnitLevel())) {
            criteria.eq("unit_level", vo.getUnitLevel());
        }
        if (Objects.nonNull(vo.getComPerson())) {
            criteria.eq("com_person", vo.getComPerson());
        }
    }

    @Override
    public ComProjectAuditNote getAuditNote(String reportObjectId, String auditUnitId, Integer auditType,Integer auditMethod, Integer showIndex) {
        ComProjectAuditNote model = new ComProjectAuditNote();
        model.setAuditObjectId(reportObjectId);
        model.setAuditUnitId(auditUnitId);
        model.setAuditType(auditType);
        model.setAuditMethod(auditMethod);
        model.setShowIndex(showIndex);
        List<ComProjectAuditNote> list = this.entityList(model);
        if (null != list && list.size() > 0)
            return list.get(0);
        else
            return null;
    }

    public void  insertAuditNote(Integer reportYear,Integer auditType,String auditObjectId,Integer auditMethod,String auditUnitId,String auditContent,Integer auditResult, Date auditDate, Integer unitLevel, Integer showIndex,String comPerson){
        ComProjectAuditNote comProjectAuditNote = new ComProjectAuditNote();
        comProjectAuditNote.setReportYear(reportYear);
        comProjectAuditNote.setAuditType(auditType);
        comProjectAuditNote.setAuditObjectId(auditObjectId);
        comProjectAuditNote.setAuditMethod(auditMethod);
        comProjectAuditNote.setAuditUnitId(auditUnitId);
        comProjectAuditNote.setAuditContent(auditContent);
        comProjectAuditNote.setAuditResult(auditResult);
        comProjectAuditNote.setAuditDate(auditDate);
        comProjectAuditNote.setUnitLevel(unitLevel);
        comProjectAuditNote.setShowIndex(showIndex);
//      comProjectAuditNote.setComPerson(comPerson);
        this.insert(comProjectAuditNote);
    }

    @Override
    public void updateAuditNote(String id, Integer auditResult, String auditContent, Integer showIndex,String comPerson,Date auditDate,Integer reportYear,String auditUnitId,Integer auditType,Integer auditMethod) {
        ComProjectAuditNote model = new ComProjectAuditNote();
        model.setId(id);
        model.setAuditResult(auditResult);
        model.setAuditContent(auditContent);
        model.setComPerson(comPerson);
        model.setAuditDate(auditDate);
        model.setShowIndex(showIndex);

        model.setReportYear(reportYear);
        model.setAuditUnitId(auditUnitId);
        model.setAuditType(auditType);
        model.setAuditMethod(auditMethod);

        this.update(model);
    }

    @Override
    public List<ComProjectAuditNoteDTO> getListByObjectId(String objectId) {
        return auditNoteInit(comProjectAuditNoteDAO.getListByObjectId(objectId));
    }

    @Override
    public List<ComProjectAuditNoteDTO> auditNoteInit(List<ComProjectAuditNoteDTO> List) {
        List.forEach((e) -> {
            if (e.getAuditResult().equals(CommonEnum.auditResult.waitAudit.getCode()))
                e.setAuditContent("未审核");
            e.setPhoto("https://zos.alipayobjects.com/rmsportal/ODTLcjxAfvqbxHnVXCYX.png");
        });
        return List;
    }
}
