package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComExpertSpecDAO;
import com.yiboshi.science.entity.ComExpertSpec;
import com.yiboshi.science.entity.SystemMenu;
import com.yiboshi.science.entity.SelectListItem;
import com.yiboshi.science.param.dto.ComExpertDTO;
import com.yiboshi.science.param.dto.ComExpertSpecDTO;
import com.yiboshi.science.param.dto.ComProjectGroupDetailDTO;
import com.yiboshi.science.param.query.ComExpertSpecQueryVO;
import com.yiboshi.science.service.ComExpertSpecService;
import com.yiboshi.science.service.ComProjectGroupDetailService;
import com.yiboshi.science.utils.AgeUtil;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
public class ComExpertSpecServiceImpl extends BaseServiceImpl<ComExpertSpecDAO, ComExpertSpecQueryVO, ComExpertSpecDTO, ComExpertSpec> implements ComExpertSpecService {

    @Autowired
    private ComExpertSpecDAO comExpertSpecDAO;

    @Autowired
    private ComProjectGroupDetailService comProjectGroupDetailService;

    @Override
    protected void setCriteriaForQuery(ComExpertSpecQueryVO vo, QueryWrapper<ComExpertSpecQueryVO> criteria) {
        if (Objects.nonNull(vo.getExpertId())) {
            criteria.eq("expert_id", vo.getExpertId());
        }
        if (Objects.nonNull(vo.getSpecId())) {
            criteria.eq("spec_id", vo.getExpertId());
        }
    }

    public void insertSpecList(List<ComExpertSpecDTO> list, String expertId) {
        if (list != null && list.size() > 0) {
            ComExpertSpec comExpertSpec = new ComExpertSpec();
            comExpertSpec.setExpertId(expertId);
            this.delete(comExpertSpec);
            for (int i = 0; i < list.size(); i++) {
                if (!isObjectNull(list.get(i))) {
                    ComExpertSpec expertSpec = new ComExpertSpec();
                    expertSpec.setExpertId(expertId);
                    expertSpec.setSpecId(list.get(i).getSpecId());
                    list.get(i).setShowIndex(i + 1);
                    this.insert(expertSpec);
                }
            }
        }
    }

    public List<String> getIdListByExpertId(String expertId) {
        return comExpertSpecDAO.getIdListByExpertId(expertId);
    }

    public List<ComExpertSpecDTO> getListByExpertId(String expertId) {
        return comExpertSpecDAO.getListByExpertId(expertId);
    }

    public Integer getExpertTypeByExpertId(String expertId) {
        List<ComExpertSpecDTO> SpecList = this.getListByExpertId(expertId);
        List<ComExpertSpecDTO> FindList = SpecList.stream().filter(e -> e.getSpecId().toLowerCase().equals("a70f06d1-b6aa-11ef-b6cb-0c42a1381189")).collect(Collectors.toList());
        //1技术专家、2财务专家
        if (null != FindList && FindList.size() > 0)
            return 2;
        else
            return 1;
    }

    public List<SelectListItem> getExpertListBySpecId(Map<String, Object> specId) {
        List<String> idList = null;
        if (specId.containsKey("specId")) {
            idList = (List<String>) specId.get("specId");
        }
        QueryWrapper<SystemMenu> wrapper = new QueryWrapper<SystemMenu>();
        if (Objects.nonNull(idList) && idList.size() > 0) {
            List<String> item = idList.stream().filter(f -> !f.equals("")).collect(Collectors.toList());
            if (Objects.nonNull(item) && item.size() > 0)
                wrapper.in("a.spec_id", item).or().in("d.parent_id", item);
//            wrapper.or(qw -> qw.in("a.spec_id", finalIdList).in("d.parent_id", finalIdList));
        }
        List<ComExpertDTO> list = comExpertSpecDAO.getExpertListBySpecId(wrapper);
        List<SelectListItem> allItem = new ArrayList<>();
        if (null != list && list.size() > 0) {
            list.forEach((e) -> {
                String description = e.getSex() + "/" + AgeUtil.getResidentAge(e.getBirthday()) + "岁/" + e.getWorkUnit();
                SelectListItem treeListItem = new SelectListItem(e.getPersonName(), e.getId(), description, false, false, new ArrayList<>());
                allItem.add(treeListItem);
            });
        }
        return allItem;
    }

    public List<SelectListItem> getExpertListBySpecIdProjId(List<String> SpecList, List<String> ProjList) {
        List<ComExpertDTO> list = comExpertSpecDAO.getExpertListBySpecIdProjId(SpecList, ProjList);
        List<SelectListItem> allItem = new ArrayList<>();
        if (null != list && list.size() > 0) {
            list.forEach((e) -> {
                String description = e.getSex() + "/" + AgeUtil.getResidentAge(e.getBirthday()) + "岁/" + e.getWorkUnit();
                SelectListItem treeListItem = new SelectListItem(e.getPersonName(), e.getId(), description, false, false, new ArrayList<>());
                allItem.add(treeListItem);
            });
        }
        return allItem;
    }

    public List<SelectListItem> getExpertListByExpertSpecIds(List<String> specIds, List<String> groupIds, String personName) {
        List<ComExpertDTO> list = new ArrayList<>();
        if ((specIds != null && specIds.size() > 0) || null != personName)
            list = comExpertSpecDAO.getExpertListByExpertSpecIds(specIds, personName);
        if (null != list && list.size() > 0) {
            List<SelectListItem> array = new ArrayList<>();
            List<String> units = new ArrayList<>();
            List<ComProjectGroupDetailDTO> project = comProjectGroupDetailService.getProjectListByGroupIds(groupIds);
            List<ComProjectGroupDetailDTO> members = comProjectGroupDetailService.getMembersListByGroupIds(groupIds);
            if (null == members) {
                members = new ArrayList<>();
            }
            List<ComProjectGroupDetailDTO> finalMembers = members;
            project.forEach(e -> {
                if (!units.contains(e.getAppUnitId()))
                    units.add(e.getAppUnitId());
                ComProjectGroupDetailDTO dto = new ComProjectGroupDetailDTO();
                dto.setPersonName(e.getPersonName());
                dto.setCertId(e.getCertId());
                dto.setAppUnitName(e.getAppUnitName());
                finalMembers.add(dto);
            });

            List<ComProjectGroupDetailDTO> finalMembers1 = members;
            list.forEach((e) -> {
                boolean isDisabled = false;
                String description = e.getSex() + "/" + AgeUtil.getResidentAge(e.getBirthday()) + "岁/" + e.getWorkUnit();
                isDisabled = units.contains(e.getUnitId());
                // 检查专家的证件号是否在 members 列表中
                if (!isDisabled)
                    isDisabled = finalMembers1.stream().anyMatch(member -> Objects.equals(member.getCertId(), e.getCertId()));
                SelectListItem treeListItem = new SelectListItem(e.getPersonName(), e.getId(), description, false, isDisabled, new ArrayList<>());
                array.add(treeListItem);
            });
            return array;
        }
        return new ArrayList<>();
    }

    public List<SelectListItem> getExpertListByExpertSpecIdOrParentId(String specId, String pkey, String ppkey, String personName) {
        List<ComExpertDTO> list = comExpertSpecDAO.getExpertListByExpertSpecIdOrParentId(specId, pkey, ppkey, personName);
        List<SelectListItem> allItem = new ArrayList<>();
        if (null != list && list.size() > 0) {
            list.forEach((e) -> {
                String description = e.getSex() + "/" + AgeUtil.getResidentAge(e.getBirthday()) + "岁/" + e.getWorkUnit();
                SelectListItem treeListItem = new SelectListItem(e.getPersonName(), e.getId(), description, false, false, new ArrayList<>());
                allItem.add(treeListItem);
            });
        }
        return allItem;
    }
}
