package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectFundPlan;
import com.yiboshi.science.param.dto.ComProjectFundPlanDTO;
import com.yiboshi.science.param.query.ComProjectFundPlanQueryVO;

import java.util.List;

/**
 * 经费申请表（任务书/项目申请书） Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectFundPlanService extends BaseService<ComProjectFundPlanQueryVO, ComProjectFundPlanDTO, ComProjectFundPlan> {
    /** 根据对象获取合作单位列表
     *
     * @param objectId
     * @return
     */
    List<ComProjectFundPlanDTO> getListByObjectId(String objectId);

    /**
     * 单位支出明细预算列表
     * @return
     */
    List<ComProjectFundPlanDTO> getList();
    /** 删除对象列表
     *
     * @param objectId
     */
    void deleteByObjectId(String objectId);
    /** 插入合作单位
     *
     * @param togetherList
     * @param objectId
     */
    void insertList(List<ComProjectFundPlanDTO> togetherList, String objectId);
}
