package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComProjectAudit;
import com.yiboshi.science.param.dto.*;
import com.yiboshi.science.param.query.ComProjectAuditQueryVO;

import java.util.Date;
import java.util.List;

/**
 * 审核表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectAuditService extends BaseService<ComProjectAuditQueryVO, ComProjectAuditDTO, ComProjectAudit> {
    /**
     * 修改/添加评审记录
     *
     * @param dto
     * @return
     */
    String save(ComProjectAuditDTO dto);
    /**
     * 删除评审记录
     *
     * @param id
     * @return
     */
    String deleteRecord(String id);
    /** 获取审核记录
     *
     * @return
     */
    ComProjectAudit getAudit(String reportObjectId, String auditUnitId, Integer auditType, Integer auditMethod, Integer unitLevel);
    /** 插入审核记录
     *
     * @return
     */
    void insertAudit(Integer reportYear, Integer auditType, String auditObjectId, Integer auditMethod, String auditUnitId, String auditContent, Integer auditResult, Date auditDate, Integer unitLevel, Integer showIndex,String comPerson);
    /** 更新审核记录
     *
     * @return
     */
    void updateAudit(String id, Integer auditResult, String auditContent, Integer showIndex,String comPerson,Date auditDate,Integer reportYear,String auditUnitId,Integer auditType,Integer auditMethod);
    /**
     * 多表分页查询
     *
     * @param vo 查询条件
     * @return 分页对象
     */
    Pagination<ComProjectAuditDTO> getAuditListByPage(ComProjectAuditQueryVO vo);

    /**
     * 审核项目列表
     * @param vo
     * @return
     */
    List<ComProjectAuditDTO> getAuditProjectList(ComProjectAuditQueryVO vo);

    /**
     * 多表分页查询
     *
     * @param vo 查询条件
     * @return 分页对象
     */
    Pagination<ComProjectAuditDTO> getStatisticListByPage(ComProjectAuditQueryVO vo);
    /** 项目/任务书/中期考核上报
     *
     * @param reportYear
     * @param reportObjectId
     * @param auditType
     * @param auditUnitId
     * @param treeCode
     */
    void report(Integer reportYear, String reportObjectId, Integer auditType,Integer auditMethod, String auditUnitId,  String treeCode);
    /** 项目/任务书/中期考核审核
     *
     * @param comProjectAudit
     * @param auditTreeCode
     * @return
     */
    String audit(ComProjectAudit comProjectAudit, String reportTreeCode,String auditTreeCode);

    /** 项目结题/论文 审核
     *
     * @param comProjectAudit
     * @param
     * @return
     */
    void audit(ComProjectAudit comProjectAudit);
    /**
     * 获取统计数据
     *
     * @return
     */
    DataStatisticsDTO getCount(ComProjectAuditQueryVO e);
    /**
     * 获取统计数据
     *
     * @return
     */
    DataStatisticsDTO getConclusionAuditCount(ComProjectAuditQueryVO e);
    /**
     * 获取统计数据
     *
     * @return
     */
    DataStatisticsDTO getTalentAuditCount(ComProjectAuditQueryVO e);
    /**
     * 根据审核对象获取对象实体
     *
     * @return
     */
    ComProjectAudit getByObjIdAndUnitId(String auditObjId,String auditUnitId);

    /**
     * 获取统计数据
     *
     * @return
     */
    DataStatisticsDTO getFirstAuditPassCount(ComProjectAuditQueryVO e);
    /**
     * 获取统计数据
     *
     * @return
     */
    DataStatisticsDTO getCountByDay(ComProjectAuditQueryVO e);
    /**
     * 科研项目分配人次
     * @param assignYear
     * @param systemType
     * @return
     */
    DataStatisticsDTO getAssignPersonCount(Integer assignYear, Integer systemType);
    /**
     * 获取统计数据
     *
     * @return
     */
    List<DataStatisticsDTO> getTreeCodeProjectCount(ComProjectAuditQueryVO e,String treeCode);
    /**
     * 获取统计数据
     *
     * @return
     */
    List<DataStatisticsDTO> getKnowledgeCount(ComProjectAuditQueryVO e);

    /**
     * 获取统计数据
     * @param vo
     * @return
     */
    List<KnowledgeStatisticsDTO> getKnowledgeStatistic(ComProjectAuditQueryVO vo);

    /**
     * 项目组二级学科选中列表
     * @param vo
     * @return
     */
    List<KnowledgeStatisticsDTO> getKnowledgeSelectedList(ComProjectAuditQueryVO vo);

    /**
     * 项目组二级学科列表
     * @param groupYear
     * @return
     */
    List<ComProjectGroupDetailDTO> getProjectGroupKnowledgeId(Integer groupYear);

    /**
     * 获取未分配的项目列表
     * @param vo
     * @return
     */
    Pagination<ComProjectAuditDTO> getUnAssignProjectListByPage(ComProjectAuditQueryVO vo);

    /**
     * 获取未分配的人才列表
     * @param vo
     * @return
     */
    Pagination<ComProjectAuditDTO> getUnAssignTalentListByPage(ComProjectAuditQueryVO vo);

    /**
     *
     * @param vo
     * @return
     */
    List<projectExpertGroupStatisticDTO> getProjectExpertGroupStatistic(ComProjectAuditQueryVO vo);

    /**
     * 项目评审结果统计
     * @param reportYear
     * @return
     */
    List<EvaluationStatisticDTO> getEvaluationStatistic(Integer reportYear);

    /**
     * 导出excel数据列表
     * @param reportYear 年度
     * @param startRow 开始行
     * @param rowMarkList excel行标列表
     * @return
     */
    EvaluationExportExcelDTO getEvaluationExportExcel(Integer reportYear, Integer startRow, List<String> rowMarkList);

    /**
     * 导出excel数据列表
     * @param reportYear 年度
     * @param startRow 开始行
     * @param rowMarkList excel行标列表
     * @return
     */
    EvaluationExportExcelDTO getProjectGroupScoreOrder(Integer reportYear, Integer startRow, List<String> rowMarkList);

    /**
     * 人才评审结果统计
     * @param reportYear
     * @return
     */
    TalentEvaluationExportExcelDTO getTalentEvaluationStatistic(Integer reportYear, Integer startRow, List<String> rowMarkList);

    /**
     * 导出excel数据列表
     * @param reportYear
     * @param startRow
     * @param rowMarkList
     * @return
     */
    TalentEvaluationExportExcelDTO getTalentGroupScoreOrder(Integer reportYear, Integer startRow, List<String> rowMarkList);
}
