package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComExpertGroupMembers;
import com.yiboshi.science.entity.SelectListItem;
import com.yiboshi.science.param.dto.ComExpertGroupMembersDTO;
import com.yiboshi.science.param.query.ComExpertGroupMembersQueryVO;

import java.util.List;


public interface ComExpertGroupMembersService extends BaseService<ComExpertGroupMembersQueryVO, ComExpertGroupMembersDTO, ComExpertGroupMembers>{

    /** 插入列表
     *
     * @param list
     * @param groupId
     */
    void insertMemberList(List<SelectListItem> list, String groupId);

    /** 根据组Id获取专家Id
     *
     * @param groupId
     */
    List<SelectListItem> getExpertIdListByGroupId(String groupId);
    /** 根据专家组Id删除专家
     *
     * @param groupId
     * @param groupId
     */
    void deleteByGroupId(String groupId);
}
