package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.SystemRole;
import com.yiboshi.science.enumeration.CommonEnum;
import com.yiboshi.science.param.dto.SystemRoleDTO;
import com.yiboshi.science.param.query.SystemRoleQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.SystemRoleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 功能：系统角色表 接口
 * @author lkl
 * @version 2021-08-26
 */
@Api(tags = "system-role",description = "系统角色表")
@RestController
@RequestMapping("/v1/science-admin/system-role")
public class SystemRoleController extends BaseController<SystemRoleService,SystemRoleQueryVO, SystemRoleDTO, SystemRole> {

    @Autowired
    private SystemRoleService systemRoleService;

    @ApiOperation(value = "获取获取系统角色", httpMethod = "GET", notes = "获取获取系统角色")
    @GetMapping
    @RequestMapping("/getSystemRole")
    public ResponseDataModel<List<SystemRole>> getUnitLevelList() {
        List<SystemRole> list = new ArrayList<>();
        SystemRole sr = new SystemRole();
        sr.setId("");
        sr.setName("--全部--");
        list.add(sr);
        for (CommonEnum.systemRole role : CommonEnum.systemRole.values()) {
            sr = new SystemRole();
            sr.setId(role.getCode().toString());
            sr.setName(role.getDescription());
            list.add(sr);
        }
        return ResponseDataModel.ok(list);
    }

    /**
     * 功能:分页查询
     *
     * @param vo 查询条件
     */
    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getListByPage")
    public ResponseDataModel<Pagination<SystemRoleDTO>> getListByPage(@Validated SystemRoleQueryVO vo, BindingResult bindingResult) {
        return ResponseDataModel.ok(systemRoleService.getListByPage(vo));
    }

    @ApiOperation(value = "通过Id获取角色", httpMethod = "GET", notes = "通过Id获取角色")
    @GetMapping
    @RequestMapping("/getRoleById")
    public ResponseDataModel<SystemRoleDTO> getRoleById(String id) {
        return ResponseDataModel.ok(systemRoleService.getRoleById(id));
    }

    @ApiOperation(value = "获取所有角色", httpMethod = "GET", notes = "获取所有角色")
    @GetMapping
    @RequestMapping("/getRoleList")
    public ResponseDataModel<List<SystemRole>> getRoleList() {
        return ResponseDataModel.ok(systemRoleService.getRoleList());
    }


    @ApiOperation(value = "1.02", httpMethod = "POST", notes = "1.02 修改角色信息")
    @RequestMapping("/updateRole")
    @PostMapping
    public ResponseDataModel<String> updateRole(@RequestBody SystemRole entity) {
        return ResponseDataModel.ok(systemRoleService.updateRole(entity));
    }

    @ApiOperation(value = "管理员添加", httpMethod = "POST", notes = "人员注册")
    @RequestMapping("/insertRole")
    @PostMapping
    public ResponseDataModel<String> insertRole(@Validated @RequestBody SystemRole entity) {
        return ResponseDataModel.ok(systemRoleService.insertRole(entity));
    }
}
