package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComProjectGroupAssign;
import com.yiboshi.science.param.dto.ComProjectGroupAssignDTO;
import com.yiboshi.science.param.query.ComProjectGroupAssignQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.ComProjectGroupAssignService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "com-project-group-assign", description = "项目组分配表")
@RestController
@RequestMapping("/v1/science-admin/com-project-group-assign")
public class ComProjectGroupAssignController extends BaseController<ComProjectGroupAssignService, ComProjectGroupAssignQueryVO, ComProjectGroupAssignDTO, ComProjectGroupAssign> {

    @Autowired
    private ComProjectGroupAssignService comProjectGroupAssignService;

    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getListByPage")
    public ResponseDataModel<Pagination<ComProjectGroupAssignDTO>> getListByPage(@Validated ComProjectGroupAssignQueryVO vo, BindingResult bindingResult) {
        Pagination<ComProjectGroupAssignDTO> page = comProjectGroupAssignService.getListByPage(vo);
        return ResponseDataModel.ok(page);
    }

    @ApiOperation(value = "根据项目组Id获取专家明细", httpMethod = "GET", notes = "根据项目组Id获取专家明细")
    @GetMapping
    @RequestMapping("/getAssignExpertList")
    public ResponseDataModel<List<ComProjectGroupAssignDTO>> getAssignExpertList(String groupId) {
        return ResponseDataModel.ok(comProjectGroupAssignService.getAssignExpertList(groupId));
    }

    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getAssignGroupExpertById")
    public ResponseDataModel<ComProjectGroupAssignDTO> getAssignGroupExpertById(String id) {
        return ResponseDataModel.ok(comProjectGroupAssignService.getAssignGroupExpertById(id));
    }
}
