package com.yiboshi.science.rest.v1;


import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.entity.ComExpertSpec;
import com.yiboshi.science.entity.SelectListItem;
import com.yiboshi.science.param.dto.ComExpertSpecDTO;
import com.yiboshi.science.param.query.ComExpertSpecQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.ComExpertSpecService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;


@Api(tags = "com-expert-spec", description = "项目分配表")
@RestController
@RequestMapping("/v1/science-admin/com-expert-spec")
public class ComExpertSpecController extends BaseController<ComExpertSpecService, ComExpertSpecQueryVO, ComExpertSpecDTO, ComExpertSpec> {

    @Autowired
    private ComExpertSpecService comExpertSpecService;


    @ApiOperation(value = "根据类型参数列表", httpMethod = "GET", notes = "根据类型参数列表")
    @GetMapping
    @RequestMapping("/getExpertListBySpecId")
    public ResponseDataModel<List<SelectListItem>> getExpertListBySpecId(@RequestBody Map<String, Object> specId) {


        return ResponseDataModel.ok(comExpertSpecService.getExpertListBySpecId(specId));
    }

    @ApiOperation(value = "根据类型参数列表", httpMethod = "GET", notes = "根据类型参数列表")
    @GetMapping
    @RequestMapping("/getExpertListBySpecIdProjId")
    public ResponseDataModel<List<SelectListItem>> getExpertListBySpecIdProjId(@RequestParam String projIds, String specIds) {
        String[] split = projIds.split(",");
        List<String> ProjList = Arrays.asList(split);

        List<String> SpecList = null;
        if (null != specIds) {
            split = specIds.split(",");
            SpecList = Arrays.asList(split);
        }

        return ResponseDataModel.ok(comExpertSpecService.getExpertListBySpecIdProjId(SpecList, ProjList));
    }

    @ApiOperation(value = "根据类型参数列表", httpMethod = "GET", notes = "根据类型参数列表")
    @GetMapping
    @RequestMapping("/getExpertListByExpertSpecIds")
    public ResponseDataModel<List<SelectListItem>> getExpertListByExpertSpecIds(@RequestBody Map<String, Object> params) {
        return ResponseDataModel.ok(comExpertSpecService.getExpertListByExpertSpecIds((List<String>) params.get("specIds"),(List<String>) params.get("groupIds"), (String) params.get("personName")));
    }


    @ApiOperation(value = "根据学科Id获取专家列表", httpMethod = "GET", notes = "根据学科Id获取专家列表")
    @GetMapping
    @RequestMapping("/getExpertListByExpertSpecIdOrParentId")
    public ResponseDataModel<List<SelectListItem>> getExpertListByExpertSpecIdOrParentId(String specId, String pkey, String ppkey, String personName) {
        return ResponseDataModel.ok(comExpertSpecService.getExpertListByExpertSpecIdOrParentId(specId, pkey, ppkey, personName));
    }
}
