package com.yiboshi.science.rest.v1;


import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComExpertBatch;
import com.yiboshi.science.param.dto.ComExpertBatchDTO;
import com.yiboshi.science.param.query.ComExpertBatchQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.ComExpertBatchService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;


@Api(tags = "com-expert-batch", description = "专家批次表")
@RestController
@RequestMapping("/v1/science-admin/com-expert-batch")
public class ComExpertBatchController extends BaseController<ComExpertBatchService, ComExpertBatchQueryVO, ComExpertBatchDTO, ComExpertBatch> {
    @Autowired
    private ComExpertBatchService comExpertBatchService;

    @ApiOperation(value = "分页查询", httpMethod = "GET", notes = "根据参数获取列表")
    @GetMapping
    @RequestMapping("/getListByPage")
    public ResponseDataModel<Pagination<ComExpertBatchDTO>> getListByPage(@Validated ComExpertBatchQueryVO vo, BindingResult bindingResult) {
        Pagination<ComExpertBatchDTO> page = comExpertBatchService.getListByPage(vo);
        return ResponseDataModel.ok(page);
    }

    @ApiOperation(value = "添加或更新批次", httpMethod = "POST", notes = "添加或更新批次")
    @RequestMapping("/save")
    @PostMapping
    public ResponseDataModel<String> save(@Validated @RequestBody ComExpertBatchDTO dto) {
        return ResponseDataModel.ok(comExpertBatchService.save(dto));
    }

    /**
     * 根据id获取批次
     *
     * @param id 查询条件
     */
    @ApiOperation(value = "根据id获取批次", httpMethod = "GET", notes = "根据id获取批次")
    @GetMapping
    @RequestMapping("/getBatchById")
    public ResponseDataModel<ComExpertBatchDTO> getBatchById(@Validated String id) {
        return ResponseDataModel.ok(comExpertBatchService.getBatchById(id));
    }

    @ApiOperation(value = "删除批次", httpMethod = "DELETE", notes = "删除批次")
    @DeleteMapping
    @RequestMapping(value = "deleteByBatchId/{id}")
    public ResponseDataModel<String> deleteByBatchId(@PathVariable String id) {
        return ResponseDataModel.ok(comExpertBatchService.deleteByBatchId(id));
    }
}
