package com.yiboshi.science.param.query;

import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 * 用户角色表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "用户角色表VO")
public class SystemUserRoleQueryVO extends PaginationVO{
    /** 用户Id */
    @ApiModelProperty(value = "用户Id", position = 4 )
    @Length(max=36, message = "用户Id不能大于36")
    private String userId;
    /** 角色Id */
    @ApiModelProperty(value = "角色Id", position = 7 )
    private String roleId;
    /** 状态 */
    @ApiModelProperty(value = "状态", position = 6)
    private Integer state;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 19 )
    @Length(max=200, message = "备注不能大于200")
    private String remark;
}